# NeuroConnect Therapy Management System - Online

A professional therapy centre management system that can be accessed from anywhere online.

## 🌐 Online Features

- **Cloud-Based**: Access from any device with internet connection
- **Secure Authentication**: JWT-based authentication with bcrypt password hashing
- **Real-time Data**: API-based data management with automatic synchronization
- **Multi-Device Support**: Responsive design works on desktop, tablet, and mobile
- **Offline Indication**: Shows network status and handles offline scenarios
- **Professional Deployment**: Ready for production hosting

## 🚀 Quick Start (Local Development)

1. **Install Dependencies**
   ```bash
   npm install
   ```

2. **Start the Server**
   ```bash
   npm start
   ```

3. **Access the Application**
   ```
   http://localhost:3000
   ```

## 🔐 Default Login Credentials

- **Administrator**: `admin` / `admin123` (Full access)
- **Staff User**: `user` / `user123` (Limited access)

## 📱 Deployment Options

### Option 1: Heroku (Recommended for Full-Stack)

1. **Install Heroku CLI**
   ```bash
   npm install -g heroku
   ```

2. **Login to Heroku**
   ```bash
   heroku login
   ```

3. **Create Heroku App**
   ```bash
   heroku create your-app-name
   ```

4. **Deploy**
   ```bash
   git add .
   git commit -m "Deploy NeuroConnect online"
   git push heroku main
   ```

5. **Open Your App**
   ```bash
   heroku open
   ```

### Option 2: Vercel (Serverless)

1. **Install Vercel CLI**
   ```bash
   npm install -g vercel
   ```

2. **Deploy**
   ```bash
   vercel
   ```

3. **Follow the prompts** and your app will be live!

### Option 3: Netlify (Static + Serverless Functions)

1. **Build for static deployment**
   ```bash
   npm run build
   ```

2. **Deploy to Netlify**
   - Connect your Git repository to Netlify
   - Set build command: `npm run build`
   - Set publish directory: `dist` or root

### Option 4: DigitalOcean App Platform

1. **Create new app** on DigitalOcean
2. **Connect your Git repository**
3. **Configure build settings**:
   - Build command: `npm install`
   - Run command: `npm start`

### Option 5: Railway

1. **Install Railway CLI**
   ```bash
   npm install -g @railway/cli
   ```

2. **Login and Deploy**
   ```bash
   railway login
   railway deploy
   ```

## 🛠️ Environment Variables

For production deployment, set these environment variables:

```bash
PORT=3000
JWT_SECRET=your-super-secret-jwt-key-here
NODE_ENV=production
```

## 📊 Features Available Online

- ✅ **Dashboard**: Real-time statistics and overview
- ✅ **Staff Management**: Add, edit, delete staff with payroll
- ✅ **Patient Records**: Comprehensive patient management
- ✅ **Therapy Scheduling**: Advanced scheduling with recurring appointments
- ✅ **Stock Control**: Inventory management
- ✅ **Expense Tracking**: Financial management in KES currency
- ✅ **Reports**: Data analytics and export functionality
- ✅ **Role-Based Access**: Admin and user permission levels
- ✅ **Data Export**: CSV export for all modules
- ✅ **Responsive Design**: Works on all device sizes

## 🔒 Security Features

- **JWT Authentication**: Secure token-based authentication
- **Password Hashing**: bcrypt password protection
- **HTTPS Ready**: Secure communication
- **CORS Protection**: Cross-origin request security
- **Helmet.js**: Security headers
- **Input Validation**: Server-side validation
- **Session Management**: Automatic token expiration

## 📁 File Structure

```
neuroconnect/
├── server.js              # Express server
├── package.json           # Dependencies
├── login-online.html      # Login page
├── index-online.html      # Main application
├── js/
│   ├── app-online.js      # Main app logic
│   ├── auth-online.js     # Authentication
│   └── [other modules]    # Feature modules
├── styles/                # CSS files
├── assets/                # Images and static files
├── data/                  # JSON data storage (auto-created)
└── README-DEPLOYMENT.md   # This file
```

## 🌍 Custom Domain Setup

After deployment, you can connect a custom domain:

1. **Purchase a domain** from any registrar
2. **Configure DNS** to point to your hosting provider
3. **Update your hosting settings** to use the custom domain
4. **Enable HTTPS** (usually automatic with modern hosts)

## 📈 Monitoring and Analytics

Consider adding these services for production:

- **Uptime Monitoring**: UptimeRobot, Pingdom
- **Error Tracking**: Sentry, Bugsnag
- **Analytics**: Google Analytics, Mixpanel
- **Performance**: New Relic, DataDog

## 🔧 Customization

To customize for your therapy centre:

1. **Update branding** in `assets/` folder
2. **Modify therapy types** in `js/schedule.js`
3. **Adjust permissions** in `server.js`
4. **Add custom fields** to data structures
5. **Integrate payment processing** if needed

## 🆘 Support

For technical support:
- Check the application logs
- Verify environment variables
- Ensure all dependencies are installed
- Check network connectivity
- Review server response codes

## 📄 License

MIT License - Use freely for your therapy centre.

---

**NeuroConnect Therapy Management System v2.0**  
*Professional therapy management accessible from anywhere*